/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class HTTP {
    private static final String USER_AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.84 Safari/537.36";

    HTTP() {
    }

    public static void GET_download(String host, String dir, List<String> cookies, String postParams, String filename) throws Exception {
        int l;
        String cookieStr = "";
        URL obj = new URL("http://" + host + dir);
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("GET");
        conn.setUseCaches(false);
        conn.addRequestProperty("Host", host);
        conn.addRequestProperty("User-Agent", USER_AGENT);
        conn.addRequestProperty("Accept-Language", "en-US,en;q=0.5");
        conn.addRequestProperty("Accept-Encoding", "gzip, deflate");
        conn.addRequestProperty("Connection", "close");
        conn.addRequestProperty("Upgrade-Insecure-Requests", "1");
        if (cookies != null) {
            for (String cookie : cookies) {
                cookieStr = cookieStr + cookie.split(";")[0] + "; ";
            }
            conn.addRequestProperty("Cookie", cookieStr);
        }
        InputStream in = conn.getInputStream();
        byte[] buffer = new byte[255];
        FileOutputStream writer = new FileOutputStream(filename);
        while ((l = in.read(buffer)) != -1) {
            writer.write(buffer, 0, l);
        }
        writer.close();
        in.close();
        HTTP.setCookies(conn.getHeaderFields().get("Set-Cookie"), cookies);
    }

    public static void POST_download(String host, String dir, List<String> cookies, String postParams, String filename) throws Exception {
        int l;
        String cookieStr = "";
        URL obj = new URL("http://" + host + dir);
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.addRequestProperty("Content-Length", Integer.toString(postParams.length()));
        conn.addRequestProperty("Host", host);
        conn.addRequestProperty("User-Agent", USER_AGENT);
        conn.addRequestProperty("Accept-Language", "en-US,en;q=0.5");
        conn.addRequestProperty("Accept-Encoding", "gzip, deflate");
        conn.addRequestProperty("Connection", "close");
        if (cookies != null) {
            for (String cookie : cookies) {
                cookieStr = cookieStr + cookie.split(";")[0] + "; ";
            }
            conn.addRequestProperty("Cookie", cookieStr);
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.writeBytes(postParams);
        wr.flush();
        wr.close();
        InputStream in = conn.getInputStream();
        byte[] buffer = new byte[255];
        FileOutputStream writer = new FileOutputStream(filename);
        while ((l = in.read(buffer)) != -1) {
            writer.write(buffer, 0, l);
        }
        writer.close();
        in.close();
        HTTP.setCookies(conn.getHeaderFields().get("Set-Cookie"), cookies);
    }

    public static String sendPOST(String host, String dir, List<String> cookies, String postParams, StringBuilder viewState, StringBuilder viewStateGenerator) throws Exception {
        String inputLine;
        String cookieStr = "";
        URL obj = new URL("http://" + host + dir);
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.addRequestProperty("Content-Length", Integer.toString(postParams.length()));
        conn.addRequestProperty("Host", host);
        conn.addRequestProperty("User-Agent", USER_AGENT);
        conn.addRequestProperty("Accept-Language", "en-US,en;q=0.5");
        conn.addRequestProperty("Accept-Encoding", "gzip, deflate");
        conn.addRequestProperty("Connection", "close");
        conn.addRequestProperty("Upgrade-Insecure-Requests", "1");
        if (cookies != null) {
            for (String cookie : cookies) {
                cookieStr = cookieStr + cookie.split(";")[0] + "; ";
            }
            conn.addRequestProperty("Cookie", cookieStr);
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.writeBytes(postParams);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        String content = "";
        while ((inputLine = in.readLine()) != null) {
            content = content + inputLine + "\n";
        }
        in.close();
        HTTP.setCookies(conn.getHeaderFields().get("Set-Cookie"), cookies);
        HTTP.updateASPVars(content, viewState, viewStateGenerator);
        return content;
    }

    public static String sendGET(String host, String dir, List<String> cookies, StringBuilder viewState, StringBuilder viewStateGenerator) throws Exception {
        String inputLine;
        String cookieStr = "";
        URL obj = new URL("http://" + host + dir);
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("GET");
        conn.setUseCaches(true);
        conn.addRequestProperty("Host", host);
        conn.addRequestProperty("User-Agent", USER_AGENT);
        conn.addRequestProperty("Accept-Language", "en-US,en;q=0.5");
        conn.addRequestProperty("Accept-Encoding", "gzip, deflate");
        conn.addRequestProperty("Connection", "close");
        conn.addRequestProperty("Upgrade-Insecure-Requests", "1");
        if (cookies != null) {
            for (String cookie : cookies) {
                cookieStr = cookieStr + cookie.split(";")[0] + "; ";
            }
            conn.addRequestProperty("Cookie", cookieStr);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        String content = "";
        while ((inputLine = in.readLine()) != null) {
            content = content + inputLine + "\n";
        }
        in.close();
        HTTP.setCookies(conn.getHeaderFields().get("Set-Cookie"), cookies);
        HTTP.updateASPVars(content, viewState, viewStateGenerator);
        return content;
    }

    public static void updateASPVars(String content, StringBuilder viewState, StringBuilder viewStateGenerator) {
        viewState.delete(0, viewState.length());
        viewStateGenerator.delete(0, viewStateGenerator.length());
        Document document = Jsoup.parse(content);
        Element viewStateElement = document.getElementById("__VIEWSTATE");
        Element viewStateGeneratorElement = document.getElementById("__VIEWSTATEGENERATOR");
        if (viewStateElement != null) {
            viewState.append(URLEncoder.encode(viewStateElement.val()));
        }
        if (viewStateGeneratorElement != null) {
            viewStateGenerator.append(URLEncoder.encode(viewStateGeneratorElement.val()));
        }
    }

    public static void setCookies(List<String> cookie, List<String> cookieList) {
        if (cookie != null) {
            if (cookieList != null) {
                cookieList.addAll(cookie);
            } else {
                cookieList = cookie;
            }
        }
    }
}

