/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json.JSONArray;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Makor {
    public static Element getDirectChild(Element parent, String name) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static void uploadSpecs(String reportStr, JSONArray additional_fields, String URL2) {
        try {
            int i;
            Document report = Makor.StringToXML(reportStr);
            Node nNode = report.getElementsByTagName("report").item(0);
            Element eElement = (Element)nNode;
            String serial = StringEscapeUtils.escapeXml(Makor.getDirectChild(eElement, "serial").getTextContent());
            String manufacturer = StringEscapeUtils.escapeXml(Makor.getDirectChild(eElement, "manufacturer").getTextContent());
            String product = StringEscapeUtils.escapeXml(Makor.getDirectChild(eElement, "product").getTextContent());
            String CPUModel = StringEscapeUtils.escapeXml(Makor.getDirectChild(Makor.getDirectChild(eElement, "CPU"), "model").getTextContent());
            String[] CPUSplit = Makor.getDirectChild(Makor.getDirectChild(eElement, "CPU"), "model").getTextContent().split("@ ");
            String CPUSpeed = StringEscapeUtils.escapeXml(CPUSplit.length > 1 ? CPUSplit[1] : "");
            String RAMSize = StringEscapeUtils.escapeXml(Makor.getDirectChild(Makor.getDirectChild(eElement, "RAM"), "size").getTextContent());
            String RAMSpeed = StringEscapeUtils.escapeXml(Makor.getDirectChild(Makor.getDirectChild(eElement, "RAM"), "speed").getTextContent());
            String RAMType = StringEscapeUtils.escapeXml(Makor.getDirectChild(Makor.getDirectChild(eElement, "RAM"), "type").getTextContent());
            String bluetooth = StringEscapeUtils.escapeXml(Makor.getDirectChild(eElement, "bluetooth").getTextContent());
            String webcam = StringEscapeUtils.escapeXml(Makor.getDirectChild(eElement, "webcam").getTextContent());
            String battery = StringEscapeUtils.escapeXml(Makor.getDirectChild(eElement, "battery").getTextContent());
            String resolution = StringEscapeUtils.escapeXml(Makor.getDirectChild(eElement, "resolution").getTextContent());
            String USB3 = StringEscapeUtils.escapeXml(Makor.getDirectChild(eElement, "USB3").getTextContent());
            String asset_id = "";
            NodeList HDDs = eElement.getElementsByTagName("HDD");
            NodeList custom_fields = null;
            if (eElement.getElementsByTagName("custom_fields").getLength() > 0) {
                custom_fields = ((Element)eElement.getElementsByTagName("custom_fields").item(0)).getElementsByTagName("field");
            }
            String apiReport = "";
            apiReport = apiReport + "<?xml version=\"1.0\"?>";
            apiReport = apiReport + "<root>";
            apiReport = apiReport + "<audit>";
            apiReport = apiReport + "<components name=\"System\">";
            apiReport = apiReport + "<component name=\"SerialNumber\">" + serial + "</component>";
            apiReport = apiReport + "<component name=\"Manufacturer\">" + manufacturer + "</component>";
            apiReport = apiReport + "<component name=\"Model\">" + product + "</component>";
            apiReport = apiReport + "</components>";
            apiReport = apiReport + "<components name=\"cpu\">";
            apiReport = apiReport + "<component name=\"model\">" + CPUModel + "</component>";
            apiReport = apiReport + "<component name=\"speed\">" + CPUSpeed + "</component>";
            apiReport = apiReport + "</components>";
            apiReport = apiReport + "<components name=\"module\">";
            apiReport = apiReport + "<component name=\"size\">" + RAMSize + "</component>";
            apiReport = apiReport + "<component name=\"speed\">" + RAMSpeed + "</component>";
            apiReport = apiReport + "<component name=\"type\">" + RAMType + "</component>";
            apiReport = apiReport + "</components>";
            for (i = 0; i < HDDs.getLength(); ++i) {
                String HDD_capacity = Makor.getDirectChild((Element)HDDs.item(i), "capacity").getTextContent();
                String HDD_serial = Makor.getDirectChild((Element)HDDs.item(i), "serial").getTextContent();
                apiReport = apiReport + "<components name=\"hdd\">";
                apiReport = apiReport + "<component name=\"disknumber\">" + (i + 1) + "</component>";
                apiReport = apiReport + "<component name=\"capacity\">" + HDD_capacity + "</component>";
                apiReport = apiReport + "<component name=\"serial\">" + HDD_serial + "</component>";
                apiReport = apiReport + "</components>";
            }
            apiReport = apiReport + "<components name=\"details\">";
            apiReport = apiReport + "<component name=\"bluetooth\">" + bluetooth + "</component>";
            apiReport = apiReport + "<component name=\"webcam\">" + webcam + "</component>";
            apiReport = apiReport + "<component name=\"battery\">" + battery + "</component>";
            apiReport = apiReport + "<component name=\"resolution\">" + resolution + "</component>";
            apiReport = apiReport + "<component name=\"USB3\">" + USB3 + "</component>";
            if (custom_fields != null) {
                for (i = 0; i < custom_fields.getLength(); ++i) {
                    for (int ii = additional_fields.length() - 1; ii >= 0; --ii) {
                        String name = ((Element)custom_fields.item(i)).getAttribute("name").toLowerCase();
                        if (name.equals(additional_fields.get(ii).toString().toLowerCase())) {
                            apiReport = apiReport + "<component name=\"" + name + "\">" + StringEscapeUtils.escapeXml(custom_fields.item(i).getTextContent()) + "</component>";
                        }
                        if (!name.equals("asset #")) continue;
                        asset_id = StringEscapeUtils.escapeXml(custom_fields.item(i).getTextContent());
                    }
                }
            }
            apiReport = apiReport + "</components>";
            apiReport = apiReport + "</audit>";
            apiReport = apiReport + "</root>";
            String encodedReport = new String(Base64.encodeBase64(apiReport.getBytes()));
            String apiString = "";
            apiString = asset_id.length() > 0 ? "{\"asset_id\": \"" + asset_id + "\", \"asset_report\": {\"report\":\"" + encodedReport + "\"}}" : "{\"serial_number\": \"" + serial + "\", \"asset_report\": {\"report\":\"" + encodedReport + "\"}}";
            Makor.doAPICall(URL2, "/api/Diagnostics/report", apiString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String doAPICall(String host, String dir, String data) throws Exception {
        String inputLine;
        String cookieStr = "";
        URL obj = new URL("http://" + host + dir);
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.addRequestProperty("Authorization", "Basic VWx0cmFYOmM3ZU00UUJR");
        conn.addRequestProperty("Content-Type", "application/json");
        conn.addRequestProperty("Host", host);
        conn.addRequestProperty("Content-Length", Integer.toString(data.length()));
        conn.addRequestProperty("Expect", "100-continue");
        conn.addRequestProperty("Connection", "close");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.writeBytes(data);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        String content = "";
        while ((inputLine = in.readLine()) != null) {
            content = content + inputLine + "\n";
        }
        in.close();
        return content;
    }

    private static Document StringToXML(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

