/*
 * Decompiled with CFR 0.152.
 */
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.HashMap;

public class Listener
implements HttpHandler {
    Request request;
    Response response;
    HttpServer server;

    Listener(int port) throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(port), 0);
        this.server.createContext("/", this);
        this.server.setExecutor(null);
        this.server.start();
    }

    public Request getRequest() {
        Request tempRequest = this.request;
        this.request = null;
        return tempRequest;
    }

    public void setResponse(String content, int code, String content_type) {
        this.response = new Response(content.getBytes(), code, content_type);
    }

    public void setResponse(File file, int code, String content_type) throws IOException {
        try {
            FileInputStream fr = new FileInputStream(file);
            System.out.println("Sending " + file.getName());
            byte[] content = new byte[(int)file.length()];
            ((InputStream)fr).read(content);
            this.response = new Response(content, code, content_type);
        }
        catch (FileNotFoundException e) {
            this.response = new Response("404 not found".getBytes(), 404, "text/plain");
            e.printStackTrace();
        }
    }

    public void setResponse(File file, int code, String content_type, String cookies) throws IOException {
        try {
            FileInputStream fr = new FileInputStream(file);
            System.out.println("Sending " + file.getName());
            byte[] content = new byte[(int)file.length()];
            ((InputStream)fr).read(content);
            this.response = new Response(content, code, content_type, cookies);
        }
        catch (FileNotFoundException e) {
            this.response = new Response("404 not found".getBytes(), 404, "text/plain");
            e.printStackTrace();
        }
    }

    public HashMap<String, String> parseParams(String input) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (input.length() > 0) {
            input = input.replaceAll("[\n\r]", "");
            String[] paramStrings = input.split("&", 0);
            for (int i = 0; i < paramStrings.length; ++i) {
                String[] pair = paramStrings[i].split("=", -1);
                params.put(URLDecoder.decode(pair[0]), URLDecoder.decode(pair[1]));
            }
        }
        return params;
    }

    @Override
    public void handle(HttpExchange t) throws IOException {
        int read;
        InputStream requestStream = t.getRequestBody();
        String requestStr = "";
        byte[] buffer = new byte[64];
        while ((read = requestStream.read(buffer)) > 0) {
            requestStr = requestStr + new String(buffer).substring(0, read);
        }
        String path = t.getRequestURI().toString();
        Headers headers = t.getRequestHeaders();
        this.response = null;
        this.request = new Request(path, requestStr, headers);
        while (this.response == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        t.getResponseHeaders().set("Content-Type", this.response.content_type);
        if (this.response.cookies.length() > 0) {
            t.getResponseHeaders().set("Set-Cookie", this.response.cookies);
        }
        t.sendResponseHeaders(this.response.code, this.response.content.length);
        OutputStream os = t.getResponseBody();
        os.write(this.response.content);
        os.close();
        this.response = null;
    }
}

