/*
 * Decompiled with CFR 0.152.
 */
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.jetty.auth.oauth2.LocalServerReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.ParentReference;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.AppendValuesResponse;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.SpreadsheetProperties;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;

public class DriveHandler {
    private static String APPLICATION_NAME;
    private static final JsonFactory JSON_FACTORY;
    private static String TOKENS_DIRECTORY_PATH;
    private static final List<String> SCOPES;
    private static final String CREDENTIALS_FILE_PATH = "/credentials.json";

    DriveHandler(String appName, String token_path) {
        APPLICATION_NAME = appName;
        TOKENS_DIRECTORY_PATH = token_path;
    }

    private static ParentReference insertFileIntoFolder(Drive service, String folderId, String fileId) {
        ParentReference newParent = new ParentReference();
        newParent.setId(folderId);
        try {
            return (ParentReference)service.parents().insert(fileId, newParent).execute();
        }
        catch (IOException e) {
            System.out.println("An error occurred: " + e);
            return null;
        }
    }

    public static boolean createSpreadsheet(String title, List<List<Object>> values, String folder) {
        try {
            Spreadsheet requestBody = new Spreadsheet();
            SpreadsheetProperties prop = new SpreadsheetProperties();
            prop.setTitle(title);
            requestBody.setProperties(prop);
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            Sheets sheetsService = new Sheets.Builder(HTTP_TRANSPORT, JSON_FACTORY, DriveHandler.getCredentials(HTTP_TRANSPORT)).setApplicationName(APPLICATION_NAME).build();
            Sheets.Spreadsheets.Create request = sheetsService.spreadsheets().create(requestBody);
            Spreadsheet response = (Spreadsheet)request.execute();
            if (response == null) {
                return false;
            }
            System.out.println(response.getSpreadsheetId());
            String ID = response.getSpreadsheetId();
            String range = "Sheet1!A:D";
            ValueRange body = new ValueRange().setValues(values);
            AppendValuesResponse result = (AppendValuesResponse)sheetsService.spreadsheets().values().append(ID, range, body).setValueInputOption("RAW").execute();
            Drive driveService = new Drive.Builder(HTTP_TRANSPORT, JSON_FACTORY, DriveHandler.getCredentials(HTTP_TRANSPORT)).setApplicationName(APPLICATION_NAME).build();
            DriveHandler.insertFileIntoFolder(driveService, folder, ID);
        }
        catch (IOException | GeneralSecurityException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean updateSpreadsheet(List<List<Object>> values, String ID, String range) {
        try {
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            Sheets sheetsService = new Sheets.Builder(HTTP_TRANSPORT, JSON_FACTORY, DriveHandler.getCredentials(HTTP_TRANSPORT)).setApplicationName(APPLICATION_NAME).build();
            ValueRange body = new ValueRange().setValues(values);
            AppendValuesResponse result = (AppendValuesResponse)sheetsService.spreadsheets().values().append(ID, range, body).setValueInputOption("RAW").execute();
            Drive drive = new Drive.Builder(HTTP_TRANSPORT, JSON_FACTORY, DriveHandler.getCredentials(HTTP_TRANSPORT)).setApplicationName(APPLICATION_NAME).build();
        }
        catch (IOException | GeneralSecurityException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static Credential getCredentials(NetHttpTransport HTTP_TRANSPORT) throws IOException {
        InputStream in = DriveHandler.class.getResourceAsStream(CREDENTIALS_FILE_PATH);
        if (in == null) {
            throw new FileNotFoundException("Resource not found: /credentials.json");
        }
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load(JSON_FACTORY, new InputStreamReader(in));
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(HTTP_TRANSPORT, JSON_FACTORY, clientSecrets, SCOPES).setDataStoreFactory(new FileDataStoreFactory(new File(TOKENS_DIRECTORY_PATH))).setAccessType("offline").build();
        LocalServerReceiver receiver = new LocalServerReceiver.Builder().setPort(8888).build();
        return new AuthorizationCodeInstalledApp(flow, receiver).authorize("user");
    }

    static {
        JSON_FACTORY = JacksonFactory.getDefaultInstance();
        SCOPES = Collections.singletonList("https://www.googleapis.com/auth/drive");
    }
}

